import java.io.*;
import java.lang.*;
import java.util.*;

class DateClass implements Serializable {

    private Date d;
    private String s;

    DateClass (String s, Date d) {
		this.s = s;
		this.d = d;
    }

    public static void main(String args[]) {
		Date d = new Date();
		DateClass corg = new DateClass("To jest test", d);
		DateClass cnew = null;
		
		// Serializacja oryginalnego obiektu klasy
		try {
			FileOutputStream fo = new FileOutputStream("dateclass.tmp");
			ObjectOutputStream so = new ObjectOutputStream(fo);
			so.writeObject(corg);
			so.flush();
			so.close();
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	
		// Deserializacja do nowego obiektu klasy
		try {
			FileInputStream fi = new FileInputStream("dateclass.tmp");
			ObjectInputStream si = new ObjectInputStream(fi);  
			cnew = (DateClass) si.readObject();
			si.close();
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	    
		// Wywietlenie w celu sprawdzenia poprawnoci
		System.out.println();
		System.out.println("Wywietlanie oryginalnej klasy...");
		System.out.println(corg);
		System.out.println();
		System.out.println("Wywietlanie nowej klasy...");
		System.out.println(cnew);
		System.out.println();
		System.out.println("Klasy oryginalna i nowa powinny by identyczne!");
		System.out.println();
   }
    
	// Konwersja klasy do bardziej czytelnego formatu. Jest to przydatne w czasie usuwania bdw
    public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(s + ": ");
		sb.append(d.toString());
		return(sb.toString());
    }
}



 









